/*
 * Decompiled with CFR 0.152.
 */
package pse.util.general;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.EntityResolver2;
import pse.util.general.Utilities;

public class XmlEntityResolver
implements EntityResolver2 {
    protected static boolean IS_LOCAL_ONLY = false;
    protected static List<String> LOCAL_DTD_SOURCES = new ArrayList<String>();

    public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
        return this.internalResolveEntity(string2);
    }

    public InputSource getExternalSubset(String string, String string2) throws SAXException, IOException {
        return null;
    }

    public InputSource resolveEntity(String string, String string2, String string3, String string4) throws SAXException, IOException {
        return this.internalResolveEntity(string4);
    }

    protected InputSource internalResolveEntity(String string) throws SAXException, IOException {
        if (string.toLowerCase().startsWith("http://")) {
            InputSource inputSource = this.findLocalResourceWithNameMunging(string.substring(7));
            if (inputSource != null) {
                return inputSource;
            }
            if (IS_LOCAL_ONLY) {
                throw new SAXException("XmlEntityResolver is in Local Only mode and can't find local resource with systemId = <" + string + ">");
            }
            return null;
        }
        if (string.toLowerCase().startsWith("https://")) {
            InputSource inputSource = this.findLocalResourceWithNameMunging(string.substring(8));
            if (inputSource != null) {
                return inputSource;
            }
            if (IS_LOCAL_ONLY) {
                throw new SAXException("XmlEntityResolver is in Local Only mode and can't find local resource with systemId = <" + string + ">");
            }
            return null;
        }
        if (string.toLowerCase().startsWith("file://")) {
            return this.findLocalResourceWithNameMunging(string.substring(7));
        }
        return this.findLocalResourceWithNameMunging(string);
    }

    protected InputSource findLocalResourceWithNameMunging(String string) {
        String string2 = string;
        InputSource inputSource = this.findLocalResourceWithNoNameMunging(string2);
        if (inputSource != null) {
            return inputSource;
        }
        if (string2.charAt(0) == '/' && (inputSource = this.findLocalResourceWithNoNameMunging(string2 = string2.substring(1))) != null) {
            return inputSource;
        }
        int n = string2.lastIndexOf("/");
        if (n >= 0 && (inputSource = this.findLocalResourceWithNoNameMunging(string2 = string2.substring(n + 1))) != null) {
            return inputSource;
        }
        String string3 = "dtd/" + string2;
        inputSource = this.findLocalResourceWithNoNameMunging(string3);
        if (inputSource != null) {
            return inputSource;
        }
        return null;
    }

    protected InputSource findLocalResourceWithNoNameMunging(String string) {
        Object object;
        for (String object22 : LOCAL_DTD_SOURCES) {
            object = new File(object22 + "/" + string);
            if (!((File)object).exists()) continue;
            try {
                return new InputSource(new FileInputStream((File)object));
            }
            catch (Throwable throwable) {
                Utilities.check(throwable);
            }
        }
        File file = new File(string);
        if (file.exists()) {
            try {
                return new InputSource(new FileInputStream(file));
            }
            catch (Throwable throwable) {
                Utilities.check(throwable);
            }
        }
        try {
            ClassLoader throwable = this.getClass().getClassLoader();
            object = throwable.getResourceAsStream(string);
            if (object != null) {
                return new InputSource((InputStream)object);
            }
        }
        catch (Throwable throwable) {
            Utilities.check(throwable);
        }
        try {
            InputStream inputStream = ClassLoader.getSystemResourceAsStream(string);
            if (inputStream != null) {
                return new InputSource(inputStream);
            }
        }
        catch (Throwable throwable) {
            Utilities.check(throwable);
        }
        return null;
    }

    public static synchronized void addLocalDtdSource(String string) {
        LOCAL_DTD_SOURCES.add(string);
    }

    public static boolean isLocalOnly() {
        return IS_LOCAL_ONLY;
    }

    public static synchronized void setIsLocalOnly(boolean bl) {
        IS_LOCAL_ONLY = bl;
    }
}

